<?php
header('Content-Type: application/json');

if (!empty($_GET['code'])) {
    try {
        // Conecta ao banco dentro de /api/max.db
        $dbPath = __DIR__ . '/max.db';
        $db = new PDO('sqlite:' . $dbPath);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Prepara e executa a consulta
        $stmt = $db->prepare("SELECT status, expiration_date FROM activations WHERE code = :code LIMIT 1");
        $stmt->execute([':code' => $_GET['code']]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            echo json_encode([
                'status' => $row['status'],
                'expiration_date' => $row['expiration_date'] ?: null
            ]);
        } else {
            echo json_encode(['status' => 'pending', 'expiration_date' => null]);
        }
    } catch (Exception $e) {
        echo json_encode(['status' => 'pending', 'expiration_date' => null]);
    }
} else {
    echo json_encode(['status' => 'pending', 'expiration_date' => null]);
}
?>
