<?php
session_start();

$db = new SQLite3('./api/.db.db');

// Recupera as informações do usuário com ID 1
$stmt = $db->prepare("SELECT * FROM users WHERE id = :id");
$stmt->bindValue(':id', 1, SQLITE3_INTEGER);
$res = $stmt->execute();
$row = $res->fetchArray(SQLITE3_ASSOC);

$message = '<div class="alert alert-success" id="flash-msg"><h4><i class="icon fa fa-check"></i> A alteração foi um sucesso!</h4></div>';

if (isset($_POST['submit'])) {
    // Hash da nova senha
    $hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);

    // Atualiza as informações do usuário
    $stmt = $db->prepare("UPDATE users SET username = :username, password = :password WHERE id = :id");
    $stmt->bindValue(':username', $_POST['username'], SQLITE3_TEXT);
    $stmt->bindValue(':password', $hashedPassword, SQLITE3_TEXT);
    $stmt->bindValue(':id', 1, SQLITE3_INTEGER);
    $stmt->execute();

    // Atualiza as variáveis de sessão
    session_regenerate_id();
    $_SESSION['loggedinLaucheV'] = TRUE;
    $_SESSION['name'] = $_POST['username'];

    // Redireciona para a página user_update.php com uma mensagem de sucesso
    header("Location: user_update.php?message=" . urlencode($message));
    exit();
}

include('includes/header.php');
?>
<div class="content-wrapper">
    <div class="container pt-5">
        <?php if (isset($_GET['message'])) { echo urldecode($_GET['message']); } ?>
        <div class="card mb-3">
            <div class="card-header">
                <i class="fa fa-address-book"></i> Alterar nome de usuário e senha
            </div>
            <div class="card-body">
                <div>
                    <div class="row">
                        <div class="col-12 text-center">
                            <h5>Editar Usuário e Senha</h5>
                        </div>
                        <div class="col-md-8 mx-auto">
                            <form method="post">
                                <div class="form-group">
                                    <label class="control-label" for="username">Usuário</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="username" name="username" value="<?= isset($row['USERNAME']) ? htmlspecialchars($row['USERNAME']) : '' ?>" required />
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label" for="password">Senha</label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" name="password" id="password" required />
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div>
                                        <button class="btn btn-primary" name="submit" type="submit">
                                            <i class="fa fa-check"></i> Salvar Nova Configuração
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br><br><br>
<?php include('includes/footer.php'); ?>
