<?php
include 'includes/header.php';

try {
    $db = new PDO('sqlite:./api/.apps.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $db->query("SELECT * FROM apks");
    $apks = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
    die();
}
?>
<div class="card-body">
    <div class="card bg-primary text-white">
        <div class="card-header card-header-warning">
            <h2>Config Geral Launcher</h2>
        </div>
        <div class="card-body">
            <div class="alert alert-primary" role="alert">
                <div class="row">
                    <div class="col-md-12 mx-auto">
                        <center>
                            <h2 class="colorboard">Aplicativos</h2>
                            <a id="button" href="upload_form.php" class="btn btn-primary">Novo Aplicativo</a>
                        </center>
                        <br>
                        <div class="table-responsive">
                            <table class="table table-striped table-sm">
                                <thead style="color:white!important">
                                    <tr>
                                        <th>Nome</th>
                                        <th>Ícone</th>
                                        <th>Pacote</th>
                                        <th>Link para baixar</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <?php foreach ($apks as $apk): ?>
                                <tbody>
                                    <tr>
                                        <td><?= htmlspecialchars($apk['nameapp']) ?></td>
                                        <td><img src="<?= htmlspecialchars($apk['iconeapp']) ?>" alt="Icone App" style="max-width: 100px; height: auto bord; border-radius: 10px;"></td>
                                        <td><?= htmlspecialchars($apk['package']) ?></td>
                                        <td><a href="<?= htmlspecialchars($apk['buylink']) ?>" target="_blank">Download</a></td>
                                        <td>
                                            <a href="edit_app.php?id=<?= $apk['id'] ?>" class="btn btn-warning btn-sm">Editar</a>
                                            <a href="#" class="btn btn-danger btn-sm" data-href="delete_app.php?id=<?= $apk['id'] ?>" data-toggle="modal" data-target="#confirm-delete">Apagar</a>
                                        </td>
                                    </tr>
                                </tbody>
                                <?php endforeach; ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                        
</div>
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="background-color: black;">
            <div class="modal-header">
                <h2 style="color: white;">Confirmar</h2>
            </div>
            <div class="modal-body" style="color: white;">
                Quer realmente apagar?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancelar</button>
                <a style="color: white;" class="btn btn-danger btn-ok">Apagar</a>
            </div>
        </div>
    </div>
</div>

<script>
$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>

<?php include 'includes/footer.php';?>
</body>
</html>